/*
 *  Board.h
 *  oseroGL
 *
 *  Created by 洲崎 将吾 on 09/12/19.
 *  Copyright 2009 __MyCompanyName__. All rights reserved.
 *
 */
//#import "graphicUtil.h"
#import <AVFoundation/AVFoundation.h>
#include "BoardBase.h"
#include "ComAI.h"

//#define MARGIN_X	(12 - 15)
//#define MARGIN_Y	(122 - 34)
#define MARGIN_X	12
#define MARGIN_Y	(122 - 20)
#define KOMA_SIZE	37
#define WAIT_INIT	10

#define CONFIG_ISBLACKPLAYER	@"isBlackPlayer"
#define CONFIG_ISWHITEPLAYER	@"isWhitePlayer"
#define CONFIG_MARKER			@"marker"
#define CONFIG_BOARD			@"board"

enum GameState
{
	GAME_READY,			// 入力受付中
	GAME_SELECTING,		// コマをどこに置くかmove中
	GAME_KOMATURN,		// コマ回転中
	GAME_PAUSE,			// 履歴遡り中とか
};

enum Players
{
	PLAYERS_PLAYER,
	PLAYERS_COM,
};

class CBoard : public CBoardBase
{
public:
	GameState		m_gameState;	// ゲーム状態
	CGPoint			m_pointer;		// ポインター位置
	CGPoint			m_lastKomaPos;	// 最後に置いたとこ
	bool			m_bSound;		// サウンドON/OFF
	bool			m_bMarker;		// マーカーON/OFF
	Players			m_playersBlack;
	Players			m_playersWhite;
	
protected:
	int				m_wait;
	AVAudioPlayer*	m_soundPut;
	UIAlertView*	msg;
	CComAI			m_comAI;
	vector<CGPoint> m_arrayPos;		// 履歴
	int				m_currentPos;	// 履歴中の何処か
	
public:
	CBoard();
	virtual ~CBoard();

protected:
	void addHistory(int x, int y);
	
public:
	// 履歴
	bool back();
	bool forward();
	void play();
	
	// 新規ゲーム
	void NewGame();
	
	void update();
	
	void loadConfig();
	void saveGame();
	void loadGame();

	// コマを置く
	void put(int x, int y);
	
	// ポインター位置からコマ位置を算出
	bool getKomaPos(CGPoint& pos);
	
	// コンピュータ思考ルーチン
	CGPoint com1();
	CGPoint com2();
};
