/*
 *  Board.cpp
 *  oseroGL2D
 *
 *  Created by 洲崎 将吾 on 09/12/25.
 *  Copyright 2009 __MyCompanyName__. All rights reserved.
 *
 */
#include "Board.h"

CBoard::CBoard() :
	m_wait(0),
	m_gameState(GAME_READY),
	m_currentPos(0)
{	
	m_bSound = false;
	m_bMarker = false;
	m_playersBlack = PLAYERS_PLAYER;
	m_playersWhite = PLAYERS_COM;

	msg = [[UIAlertView alloc] initWithTitle:nil message:@"置くところがありません" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"Pass!", nil];
	
	//サウンドを読み込みます
	//効果音用のAVAudioPlayerを生成します
	NSString *hitSoundFilePath = [[NSBundle mainBundle] pathForResource:@"explosion" ofType:@"wav"];  
	NSURL *hitSoundFileUrl = [NSURL fileURLWithPath:hitSoundFilePath];  
	m_soundPut = [[AVAudioPlayer alloc] initWithContentsOfURL:hitSoundFileUrl error:nil];
	[m_soundPut prepareToPlay];
	
	// 初期設定
	NewGame();
	loadConfig();
	loadGame();
	
// 初期配置データ設定：テスト用
/*
	int map[BOARD_X][BOARD_Y] =
	{
		{0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,1},
		{0,0,0,0,0,0,0,1},
		{0,0,1,1,1,1,2,1},
		{0,2,2,2,2,2,1,1},
		{0,1,1,1,1,1,1,1},
		{0,0,1,1,1,1,0,1},
		{0,0,1,1,1,1,1,0},
	};
	
	m_nokori = 0;
	
	for(int x = 0; x < 8; x++)
	{
		for(int y = 0; y < 8; y++)
		{
			m_map[x+1][y+1] = (KomaState)map[y][x];
			
			if(map[x][y] == KOMA_NONE)
				m_nokori ++;
		}
	}
 */
}

CBoard::~CBoard()
{
	[msg release];
}

void CBoard::NewGame()
{
	srand(time(nil));
	
	initialize();
	
	m_wait = 0;
	m_gameState = GAME_READY;
	
	m_arrayPos.clear();		// 履歴
	m_currentPos = 0;		// 履歴中の何処か	
}

void CBoard::update()
{
	if(m_gameState == GAME_PAUSE)
		return;
	
	if(m_wait > 0)
	{
		m_wait --;
		
		if(m_wait == 0)
		{
			switch(m_gameState)
			{
				case GAME_KOMATURN:
					m_gameState = GAME_READY;
					break;
			}
		}
	}
	else
	{
		if(isGameOver())
		{
			return;
		}
		
		// パスなら確認メッセージ表示：暫定
		if(isPass() && !msg.visible)
		{
			// iPhone SDK P102参照
			[msg show];
			
			m_turn = getNextTurn();
		}

		if((m_turn == KOMA_BLACK && m_playersBlack == PLAYERS_COM) ||
		   (m_turn == KOMA_WHITE && m_playersWhite == PLAYERS_COM))
		{
			CGPoint pos = com2();
			put(pos.x, pos.y);
		}
	}
}

void CBoard::loadConfig()
{
	NSUserDefaults* def = [NSUserDefaults standardUserDefaults];

	m_playersBlack = [def boolForKey:CONFIG_ISBLACKPLAYER] ? PLAYERS_PLAYER : PLAYERS_COM;
	m_playersWhite = [def boolForKey:CONFIG_ISWHITEPLAYER] ? PLAYERS_PLAYER : PLAYERS_COM;
	m_bMarker = [def boolForKey:CONFIG_MARKER] ? true : false;
	
	NSLog(@"black=%d", m_playersBlack);
}

void CBoard::saveGame()
{
	NSMutableArray* array = [NSMutableArray array];	
	for(int n = 0; n < m_arrayPos.size(); n++)
	{
		// CGPointを直接Arrayに格納できないので変換
		CGPoint pos = m_arrayPos[n];
//		NSValue* val = [NSValue valueWithCGPoint:pos];	//	CGPointは直接NSArrayに入れられないので変換
//		[array addObject:val];		// NSValueのarrayは格納できないみたい。たぶん
//		[array addObject:@"gorua"];	// 文字列とかはOK
		
		NSString* str = [NSString stringWithFormat:@"%d,%d", (int)pos.x, (int)pos.y];
		[array addObject:str];
	}
	
//	NSUserDefaults* def = [NSUserDefaults standardUserDefaults];
//	[def setObject:array forKey:CONFIG_BOARD];
		
//	if(![def synchronize])
//	{
//		NSLog(@"SaveGame() NG");
//	}
	
	NSArray* paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString* documentDir = [paths objectAtIndex:0];
	NSString* dataPath = [documentDir stringByAppendingPathComponent:@"koma.xml"];
	
	NSLog(dataPath);
	
	// atomically が NO なら直接そのファイルに出力。YESなら一旦テンポラリに書いてからリネーム
	[array writeToFile:dataPath atomically:NO];
}

void CBoard::loadGame()
{
/*
	NSUserDefaults* def = [NSUserDefaults standardUserDefaults];
	NSArray* array = [def arrayForKey:CONFIG_BOARD];

	m_arrayPos.clear();
	for(int n = 0; n < [array count]; n++)
	{
		NSValue* val = [array objectAtIndex:n];
		CGPoint pos = [val CGPointValue];
		put(pos.x, pos.y);
	}
*/
	
//	return;

	NSArray* paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString* documentDir = [paths objectAtIndex:0];
	NSString* dataPath = [documentDir stringByAppendingPathComponent:@"koma.xml"];
	
	NSLog(dataPath);

	// ファイル存在するか？
	NSFileManager *fileManager = [NSFileManager defaultManager];
	BOOL success = [fileManager fileExistsAtPath:dataPath];
	if(success)
	{
		NSArray* array = [[NSArray alloc] initWithContentsOfFile:dataPath];
		
		for(int i = 0; i < [array count]; i++)
		{
			NSString* str = [array objectAtIndex:i];
			NSArray* val = [str componentsSeparatedByString:@","];
			
			NSInteger x = [[val objectAtIndex:0] intValue];
			NSInteger y = [[val objectAtIndex:1] intValue];
			
			addHistory(x, y);
		}	
	} 
}

// コマを置く
void CBoard::put(int x, int y)
{
	// 置ける？
	if(canPut(x, y))
	{
		//効果音を巻き戻して再生します
		if(m_bSound)
		{
			[m_soundPut setCurrentTime:0.0f];
			[m_soundPut play];
		}
		
		// 履歴追加
		addHistory(x, y);

		m_gameState = GAME_KOMATURN;
		m_wait = WAIT_INIT;
	}
}

// 履歴追加
void CBoard::addHistory(int x, int y)
{
	CBoardBase::put(x, y);
	
	m_lastKomaPos.x = x;
	m_lastKomaPos.y = y;
	
	// 履歴追加
	m_currentPos ++;
	if(m_currentPos > m_arrayPos.size())
		m_arrayPos.push_back(CGPointMake(x,y));
	else
		m_arrayPos[m_currentPos - 1] = CGPointMake(x,y);
	
	//NSLog(@"pos = %d ... %d,%d", m_currentPos, x, y);
	
	saveGame();
}

// ポインター位置からコマ位置を算出
bool CBoard::getKomaPos(CGPoint& pos)
{
	int x = (m_pointer.x - MARGIN_X) / KOMA_SIZE + 1;
	int y = (m_pointer.y - MARGIN_Y) / KOMA_SIZE + 1;
	
	pos.x = x;
	pos.y = y;
	
	return (x >= 1 && x <= BOARD_X && y >= 1 && y <= BOARD_Y) ? true : false;
}

bool CBoard::back()
{
	bool bRet = false;
	
	if(m_currentPos > 0)
	{
		bRet = true;
		
		m_gameState = GAME_PAUSE;
		
		m_currentPos --;
		
		initialize();
		
		for(int n = 0; n < m_currentPos; n++)
		{
			//NSLog(@"backpos = %d ... %f,%f", n, m_arrayPos[n].x, m_arrayPos[n].y);
			CBoardBase::put(m_arrayPos[n]);
		}
	}
	
	return bRet;
}

bool CBoard::forward()
{
	bool bRet = false;
	
	if(m_currentPos < m_arrayPos.size())
	{
		bRet = true;
		
		m_gameState = GAME_PAUSE;
	
		m_currentPos ++;
	
		CBoardBase::put(m_arrayPos[m_currentPos-1]);
	}
	
	return bRet;
}

void CBoard::play()
{
	m_gameState = GAME_READY;
}

CGPoint CBoard::com1()
{
	CGPoint pos = CGPointMake(0, 0);
	
	static int map[BOARD_X+2][BOARD_Y+2] =
	{
		{0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{0, 9, 3, 6, 5, 5, 6, 3, 9, 0},
		{0, 3, 0, 3, 3, 3, 3, 0, 3, 0},
		{0, 6, 3, 4, 4, 4, 4, 3, 6, 0},
		{0, 5, 3, 4, 4, 4, 4, 3, 5, 0},
		{0, 5, 3, 4, 4, 4, 4, 3, 5, 0},
		{0, 6, 3, 4, 4, 4, 4, 3, 6, 0},
		{0, 3, 0, 3, 3, 3, 3, 0, 3, 0},
		{0, 9, 3, 6, 5, 5, 6, 3, 9, 0},
		{0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	};
	
	int maxPriority = -1;
	for(int priority = 9; priority >= 0; priority --)
	{
		for(int x = 1; x <= BOARD_X; x++)
		{
			for(int y = 1; y <= BOARD_Y; y++)
			{
				if(map[x][y] == priority && canPut(x, y))
				{
					if(maxPriority == -1)
					{
						maxPriority = priority;
						pos = CGPointMake(x, y);
					}
					else if(maxPriority == priority)
					{
						// 同じpriorityなら半分の確立で新しい座標を採用
						if(rand() % 2 == 0)
						{
							pos = CGPointMake(x, y);
						}
					}
					else
						return pos;
				}
			}
		}
	}
	
	return pos;
}

CGPoint CBoard::com2()
{
	m_comAI.setBoard((int*)m_map, m_nokori, m_turn);
	
	CGPoint pos = m_comAI.getBestPos();
	
	return pos;
}

