/*
 *  BoardBase.h
 *  oseroGL2D
 *
 *  Created by 洲崎 将吾 on 09/12/31.
 *  Copyright 2009 __MyCompanyName__. All rights reserved.
 *
 */
#pragma once;

#include <vector>
using namespace std;

#define BOARD_X		8
#define BOARD_Y		8

enum KomaState
{
	KOMA_NG		= -1,
	KOMA_NONE	= 0,
	KOMA_BLACK	= 1,
	KOMA_WHITE	= 2,
};

class CBoardBase
{
public:
	KomaState		m_map[BOARD_X + 2][BOARD_Y + 2];
	KomaState		m_turn;			// どっちのターン？
	
protected:
	static int		m_addX[];
	static int		m_addY[];
	int				m_nokori;		// 残り何コマ？
	
public:
	CBoardBase();
	virtual ~CBoardBase();
	
protected:
	// 初期状態にする
	void initialize();
	
	// 次は誰？
	KomaState getNextTurn(){ return m_turn == KOMA_BLACK ? KOMA_WHITE : KOMA_BLACK; }
	
	// 何コマ置いてる？
	int getKomaTotal(){ return BOARD_X * BOARD_Y - getKomaNokori(); }
	
	// コマ残りいくつ？
	int getKomaNokori(){ return m_nokori; }
	
	// その場所のコマは？
	KomaState getKoma(int x, int y){ return m_map[x][y]; }
	
	// ターンチェンジ
	void changeTurn(){ m_turn = getNextTurn(); };
	
public:
	// 今何手目？
	int getNanteme(){ return BOARD_X * BOARD_Y - getKomaNokori() - 4 + 1; };	
	
	// 置ける？
	bool canPut(int x, int y);
	bool canPut(int x, int y, vector<CGPoint> &arrayPoint);
	
	// コマを置く
	bool put(int x, int y);
	bool put(CGPoint pos){ return put((int)pos.x, (int)pos.y); }
	
	// 何対何？
	void getKomaTotal(int &black, int &white);
	
	// 置けるとこ全部列挙
	bool getCanPutPos(vector<CGPoint> &arrayPoint);
	
	// パス？
	bool isPass();
	
	// ゲームオーバー？
	bool isGameOver();
	
	// 勝者は？
	KomaState getWinner();
};
