/*
 *  BoardBase.cpp
 *  oseroGL2D
 *
 *  Created by 洲崎 将吾 on 09/12/31.
 *  Copyright 2009 __MyCompanyName__. All rights reserved.
 *
 */

#include "BoardBase.h"

// 上から時計回りに８方向
int CBoardBase::m_addX[] = { 0, 1, 1, 1, 0, -1, -1, -1 };
int	CBoardBase::m_addY[] = { -1, -1, 0, 1, 1, 1, 0, -1 };

CBoardBase::CBoardBase()
{
	initialize();
}

CBoardBase::~CBoardBase()
{
}

// 初期状態にする
void CBoardBase::initialize()
{
	m_turn = KOMA_BLACK;
	m_nokori = 8 * 8 - 4;
	
	int x, y;
	for(x = 0; x < BOARD_X+1; x++)
	{
		m_map[x][0] = KOMA_NG;
		m_map[x][BOARD_Y + 1] = KOMA_NG;
	}
	
	for(y = 0; x < BOARD_Y+1; y++)
	{
		m_map[0][y] = KOMA_NG;
		m_map[BOARD_X + 1][y] = KOMA_NG;
	}
	
	for(x = 1; x <= BOARD_X; x++)
		for(y = 1; y <= BOARD_Y; y++)
			m_map[x][y] = KOMA_NONE;
	
	m_map[4][4] = KOMA_WHITE;
	m_map[5][5] = KOMA_WHITE;
	m_map[4][5] = KOMA_BLACK;
	m_map[5][4] = KOMA_BLACK;
}

// 置ける？
bool CBoardBase::canPut(int x, int y)
{
	vector<CGPoint> array;
	return canPut(x, y, array);
}
bool CBoardBase::canPut(int x, int y, vector<CGPoint> &arrayPoint)
{
	arrayPoint.clear();
	
	if(x >= 1 && x <= BOARD_X && y >= 1 && y <= BOARD_Y && m_map[x][y] == KOMA_NONE)
	{
		// 上から時計回りに８方向		
		for(int n = 0; n < 8; n++)
		{
			int xx = x;
			int yy = y;
			
			vector<CGPoint> array;
			
			do
			{
				xx += m_addX[n];
				yy += m_addY[n];
				
				if(m_map[xx][yy] != getNextTurn())
					break;
				
				array.push_back(CGPointMake(xx,yy));
			}while(true);
			
			// 挟んだ？
			if(m_map[xx][yy] == m_turn)
			{					
				// listならmergeできるんだけどなぁ
				arrayPoint.insert(arrayPoint.end(), array.begin(), array.end());
			}
		}
	}
	
	return arrayPoint.size() > 0 ? true : false;
}

// コマを置く
bool CBoardBase::put(int x, int y)
{
	bool bRet = false;
	
	// ひっくり返すコマ
	vector<CGPoint> arrayPoint;
	
	// 置ける？
	if(canPut(x, y, arrayPoint))
	{
		m_map[x][y] = m_turn;
		
		m_nokori --;
		
		// ひっくり返す
		for(int n = 0; n < arrayPoint.size(); n++)
		{
			CGPoint pos = arrayPoint[n];
			m_map[(int)pos.x][(int)pos.y] = m_turn;
		}
		
		changeTurn();
		
		bRet = true;
	}
	
	return bRet;
}

void CBoardBase::getKomaTotal(int &black, int &white)
{
	black = 0;
	white = 0;
	
	for(int x = 1; x <= BOARD_X; x++)
	{
		for(int y = 1; y <= BOARD_Y; y++)
		{
			switch(m_map[x][y])
			{
				case KOMA_BLACK:
					black ++;
					break;
				case KOMA_WHITE:
					white ++;
					break;
			}
		}
	}
}

// 置けるとこ全部列挙
bool CBoardBase::getCanPutPos(vector<CGPoint> &arrayPoint)
{
	arrayPoint.clear();
	
	for(int x = 1; x <= BOARD_X; x++)
	{
		for(int y = 1; y <= BOARD_Y; y++)
		{
			if(canPut(x, y))
			{
				arrayPoint.push_back(CGPointMake(x, y));
			}
		}
	}
	
	return arrayPoint.size() > 0 ? true : false;
}

// パス？
bool CBoardBase::isPass()
{
	vector<CGPoint> array;
	return !getCanPutPos(array);
}

// ゲームオーバー？
bool CBoardBase::isGameOver()
{
	bool bOver = false;
	
	if(m_nokori == 0)
	{
		// 置くとこなくなった
		bOver = true;
	}
	else
	{
		// どっちもパス？
		if(isPass())
		{
			changeTurn();
			if(isPass())
			{
				bOver = true;
			}
			
			// 元にもどしておく
			changeTurn();
		}
		
		// 全滅？
		int black, white;
		getKomaTotal(black, white);
		if(black == 0 || white == 0)
		{
			bOver = true;
		}
	}
	
	return bOver;
}

KomaState CBoardBase::getWinner()
{
	int black, white;
	getKomaTotal(black, white);
	
	if(black > white)
		return KOMA_BLACK;
	else if(white > black)
		return KOMA_WHITE;
	else
		return KOMA_NONE;	// 引き分け
}
