/*
 *  ComAI.h
 *  oseroGL2D
 *
 *  Created by 洲崎 将吾 on 10/01/01.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include "BoardBase.h"

class CComAI : public CBoardBase
{
	KomaState	m_myKoma;
	KomaState	m_youKoma;
	
public:
	CComAI();
	virtual ~CComAI();

protected:
	// 定石と合致する？
	bool matchMap(int map[BOARD_X][BOARD_Y], CGPoint &retPos);
	
	int getMyScore(int limit);
	
	int getYouScore(int limit);
//	int getYouScore();
	
	int calcScore();
	int calcCorner(KomaState koma);
	int calcFix(KomaState koma);
	int calcX(KomaState koma);
	int calcC(KomaState koma);
	int calcWing(KomaState koma);
	int calcOpen(KomaState koma);
	int calcDoubleA(KomaState koma);
	int calcCanPut(KomaState koma);
	
	bool isFix(int x, int y, KomaState koma);
	
public:
	void setBoard(int* pmap, int nokori, KomaState turn)
	{ 
		memcpy(m_map, pmap, sizeof m_map);
		m_nokori = nokori;
		m_turn = turn;
		m_myKoma = turn;
		m_youKoma = getNextTurn();
	}
	
	// 最善の手は？
	CGPoint getBestPos();
	
	// 評価
	int getScore(CGPoint& pos, int sakiyomi, int total);
	
	// 定石に置ける？
	bool isJouseki(CGPoint& pos);
};
