/*
 *  ComAI.cpp
 *  oseroGL2D
 *
 *  Created by 洲崎 将吾 on 10/01/01.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include "ComAI.h"

CComAI::CComAI()
{
}

CComAI::~CComAI()
{
}

CGPoint CComAI::getBestPos()
{
	CGPoint pos = CGPointMake(0, 0);
	
	if(isJouseki(pos))
	{
		return pos;
	}
	
	// 盤の状態を保持
	KomaState map[BOARD_X + 2][BOARD_Y + 2];
	memcpy(map, m_map, sizeof map);
	KomaState turn = m_turn;
	
	int sakiyomiMax = 2;	// 何手先まで読む？ ※これ以上増やすとバカになるｗ
	int scoreMax = INT_MIN;
	
	// 置けるとこ全部置いてみて、それぞれの評価値の最も大きいとこに置く
	vector<CGPoint> array;
	getCanPutPos(array);
	for(int n = 0; n < array.size(); n++)
	{		
		// 手を打つ
		put(array[n].x, array[n].y);
		
		//int score = calcScore();
		
		int score = getYouScore(sakiyomiMax - 1);		
		if(score >= scoreMax)	// ※＝がないと、何処に置いても全滅するような場合、どこにも置かないので対処
		{
			pos = array[n];
			scoreMax = score;
		}
		
		NSLog(@"getBestPos : %d, %d score=%d", (int)array[n].x, (int)array[n].y, score);
		
		// 保持しておいた状態に戻す
		memcpy(m_map, map, sizeof map);
		m_turn = turn;
		m_nokori ++;
	}
	
	return pos;
}

int CComAI::getMyScore(int limit)
{
	if(isGameOver() || limit == 0)
		return calcScore();
	
	//	if(isPass())
	//		return - INT_MAX;
	
	// 盤の状態を保持
	KomaState map[BOARD_X + 2][BOARD_Y + 2];
	memcpy(map, m_map, sizeof map);
	KomaState turn = m_turn;
	
	// 置けるとこ全部列挙
	vector<CGPoint> array;
	getCanPutPos(array);
	
	int scoreMax = 0;
	for(int n = 0; n < array.size(); n++)
	{
		// 置いてみる
		put(array[n].x, array[n].y);
		
		// 相手の最善手はどこかな？
		int score = getYouScore(limit - 1);
		if(score > scoreMax)
		{
			scoreMax = score;
		}
		
		//NSLog(@"getMyScore : %d, %d score=%d", (int)array[n].x, (int)array[n].y, score);
		
		// 保持しておいた状態に戻す
		memcpy(m_map, map, sizeof map);
		m_turn = turn;
		m_nokori ++;
	}	
	
	return - scoreMax;
}

int CComAI::getYouScore(int limit)
{
	if(isGameOver() || limit == 0)
		return calcScore();
	
	//	if(isPass())
	//		return INT_MAX;
	
	// 盤の状態を保持
	KomaState map[BOARD_X + 2][BOARD_Y + 2];
	memcpy(map, m_map, sizeof map);
	KomaState turn = m_turn;
	
	// 置けるとこ全部列挙
	vector<CGPoint> array;
	getCanPutPos(array);
	
	int scoreMin = INT_MAX;
	for(int n = 0; n < array.size(); n++)
	{
		// 置いてみる
		put(array[n].x, array[n].y);
		
		// 自分の最善手はどこかな？
		int score = getMyScore(limit - 1);
		if(score < scoreMin)
		{
			scoreMin = score;
		}
		
		//NSLog(@"getYouScore : %d, %d score=%d", (int)array[n].x, (int)array[n].y, score);
		
		// 保持しておいた状態に戻す
		memcpy(m_map, map, sizeof map);
		m_turn = turn;
		m_nokori ++;
	}	
	
	return scoreMin;
}
/*
 int CComAI::getYouScore()
 {	
 //	if(isPass())
 //		return INT_MAX;
 
 // 盤の状態を保持
 KomaState map[BOARD_X + 2][BOARD_Y + 2];
 memcpy(map, m_map, sizeof map);
 KomaState turn = m_turn;
 
 // 置けるとこ全部列挙
 vector<CGPoint> array;
 getCanPutPos(array);
 
 int scoreMax = 0;
 for(int n = 0; n < array.size(); n++)
 {
 // 置いてみる
 put(array[n].x, array[n].y);
 
 // 自分の最善手はどこかな？
 int score = calcScore();
 if(score > scoreMax)
 {
 scoreMax = score;
 }
 
 //NSLog(@"getYouScore : %d, %d score=%d", (int)array[n].x, (int)array[n].y, score);
 
 // 保持しておいた状態に戻す
 memcpy(m_map, map, sizeof map);
 m_turn = turn;
 m_nokori ++;
 }	
 
 return scoreMax;
 }
 */

// 常に自分にとっての評価値を返す
int CComAI::calcScore()
{
	int score = 0;

	// 全滅判定
	int black, white;
	getKomaTotal(black, white);
	if(black == 0)
	{
		return m_myKoma == KOMA_BLACK ? INT_MIN : INT_MAX;
	}
	else if(white == 0)
	{
		return m_myKoma == KOMA_WHITE ? INT_MIN : INT_MAX;
	}
	
	// 角
	score += calcCorner(m_myKoma);
	score -= calcCorner(m_youKoma);
	
	// 確定石
	score += calcFix(m_myKoma);
	score -= calcFix(m_youKoma);
	
	// X
	score += calcX(m_myKoma);
	score -= calcX(m_youKoma);
	
	// C
	score += calcC(m_myKoma);
	score -= calcC(m_youKoma);
	
	// wing
	score += calcWing(m_myKoma);
	score -= calcWing(m_youKoma);
	
	// 開放度
	score += calcOpen(m_myKoma);
	score -= calcOpen(m_youKoma);
	
	// ダブルA打ち
	score += calcDoubleA(m_myKoma);
	score -= calcDoubleA(m_youKoma);

	// 自分が置けるとこが多いほど良い
	score += calcCanPut(m_myKoma);		// 現在の手番についてのみ
//	score -= calcCanPut(m_youKoma);
	
	return score;
}

int CComAI::calcCanPut(KomaState koma)
{
	int score = 0;
	
	KomaState save = m_turn;
	vector<CGPoint> array;
	
	m_turn = m_myKoma;
	if(getCanPutPos(array))
	{
//		score += array.size() * 67;
		score += array.size() * 5;
	}
		
	m_turn = save;
	
	return score;
}

int CComAI::calcCorner(KomaState koma)
{
	int score = 0;
	
	if(m_map[1][1] == koma)
		score += 1000;
	if(m_map[8][1] == koma)
		score += 1000;
	if(m_map[1][8] == koma)
		score += 1000;
	if(m_map[8][8] == koma)
		score += 1000;
	
	return score;
}

// @todo 連続してなくても確定石になるものがあるから、実装すること
int CComAI::calcFix(KomaState koma)
{
	int score = 0;
	int x, y;
	
	// 左上→右上
	for(x = 1; x <= 8; x++)
	{
		if(m_map[x][1] == koma)
			score += 100;
		else
			break;
	}
	for(x = 8; x >= 1; x--)
	{
		if(m_map[x][1] == koma)
			score += 100;
		else
			break;
	}
	
	// 左下→右下
	for(x = 1; x <= 8; x++)
	{
		if(m_map[x][8] == koma)
			score += 100;
		else
			break;
	}
	for(x = 8; x >= 1; x--)
	{
		if(m_map[x][8] == koma)
			score += 100;
		else
			break;
	}
	
	// 左上→左下
	for(y = 1; y <= 8; y++)
	{
		if(m_map[1][y] == koma)
			score += 100;
		else
			break;
	}
	for(y = 8; y >= 1; y--)
	{
		if(m_map[1][y] == koma)
			score += 100;
		else
			break;
	}
	
	// 右上→右下
	for(y = 1; y <= 8; y++)
	{
		if(m_map[8][y] == koma)
			score += 100;
		else
			break;
	}
	for(y = 8; y >= 1; y--)
	{
		if(m_map[8][y] == koma)
			score += 100;
		else
			break;
	}
	
	return score;
}

// 危険なX打ち：隅が取られていない状態でのX打ちはマイナス評価
int CComAI::calcX(KomaState koma)
{
	int score = 0;
	
	if(m_map[2][2] == koma && m_map[1][1] == KOMA_NONE)
		score -= 449;
	if(m_map[7][2] == koma && m_map[8][1] == KOMA_NONE)
		score -= 449;
	if(m_map[2][7] == koma && m_map[1][8] == KOMA_NONE)
		score -= 449;
	if(m_map[7][7] == koma && m_map[8][8] == KOMA_NONE)
		score -= 449;
	
	return score;
}

// 危険なC打ち：隅が取られていない状態でのC打ちはマイナス評価
// ※但し、確定石としてのC打ちは問題ない
int CComAI::calcC(KomaState koma)
{
	int score = 0;
	
	if(m_map[1][1] == KOMA_NONE)
	{
		if(m_map[2][1] == koma && !isFix(2,1,koma))
			score -= 552;
		if(m_map[1][2] == koma && !isFix(1,2,koma))
			score -= 552;
	}
	if(m_map[8][1] == KOMA_NONE)
	{
		if(m_map[7][1] == koma && !isFix(7,1,koma))
			score -= 552;
		if(m_map[8][2] == koma && !isFix(8,2,koma))
			score -= 552;
	}
	if(m_map[1][8] == KOMA_NONE)
	{
		if(m_map[1][7] == koma && !isFix(1,7,koma))
			score -= 552;
		if(m_map[2][8] == koma && !isFix(2,8,koma))
			score -= 552;
	}
	if(m_map[8][8] == KOMA_NONE)
	{
		if(m_map[8][7] == koma && !isFix(8,7,koma))
			score -= 552;
		if(m_map[7][8] == koma && !isFix(7,8,koma))
			score -= 552;
	}
	
	return score;
}

// 確定石か？
// @todo もっと条件が細かいはずだけど、暫定
bool CComAI::isFix(int kx, int ky, KomaState koma)
{
	int x, y;
	
	// 四辺のコマなら判定は簡単
	if(kx == 1 || kx == 8)
	{
		for(y = 1; y <= 8; y++)
		{
			if(getKoma(kx, y) == koma)
			{
				if(ky == y)
					return true;
			}
			else
				break;
		}
		for(y = 8; y >= 1; y--)
		{
			if(getKoma(kx, y) == koma)
			{
				if(ky == y)
					return true;
			}
			else
				break;
		}
	}
	if(ky == 1 || ky == 8)
	{
		for(x = 1; x <= 8; x++)
		{
			if(getKoma(x, ky) == koma)
			{
				if(kx == x)
					return true;
			}
			else
				break;
		}
		for(x = 8; x >= 1; x--)
		{
			if(getKoma(x, ky) == koma)
			{
				if(kx == x)
					return true;
			}
			else
				break;
		}
	}
		
	return false;
}

int CComAI::calcWing(KomaState koma)
{
	int score = 0;

	// 上辺
	if(m_map[1][1] == KOMA_NONE && m_map[7][1] == KOMA_NONE && m_map[8][1] == KOMA_NONE)
	{
		int wing = m_map[2][1] + m_map[3][1] + m_map[4][1] + m_map[5][1] + m_map[6][1];
		if(wing == koma * 5)
			score -= 308;
	}
	if(m_map[1][1] == KOMA_NONE && m_map[2][1] == KOMA_NONE && m_map[8][1] == KOMA_NONE)
	{
		int wing = m_map[3][1] + m_map[4][1] + m_map[5][1] + m_map[6][1] + m_map[7][1];
		if(wing == koma * 5)
			score -= 308;
	}

	// 下辺
	if(m_map[1][8] == KOMA_NONE && m_map[7][8] == KOMA_NONE && m_map[8][8] == KOMA_NONE)
	{
		int wing = m_map[2][8] + m_map[3][8] + m_map[4][8] + m_map[5][8] + m_map[6][8];
		if(wing == koma * 5)
			score -= 308;
	}
	if(m_map[1][8] == KOMA_NONE && m_map[2][8] == KOMA_NONE && m_map[8][8] == KOMA_NONE)
	{
		int wing = m_map[3][8] + m_map[4][8] + m_map[5][8] + m_map[6][8] + m_map[7][8];
		if(wing == koma * 5)
			score -= 308;
	}
	
	// 左辺
	if(m_map[1][1] == KOMA_NONE && m_map[1][7] == KOMA_NONE && m_map[1][8] == KOMA_NONE)
	{
		int wing = m_map[1][2] + m_map[1][3] + m_map[1][4] + m_map[1][5] + m_map[1][6];
		if(wing == koma * 5)
			score -= 308;
	}
	if(m_map[1][1] == KOMA_NONE && m_map[1][2] == KOMA_NONE && m_map[1][8] == KOMA_NONE)
	{
		int wing = m_map[1][3] + m_map[1][4] + m_map[1][5] + m_map[1][6] + m_map[1][7];
		if(wing == koma * 5)
			score -= 308;
	}

	// 右辺
	if(m_map[8][1] == KOMA_NONE && m_map[8][7] == KOMA_NONE && m_map[8][8] == KOMA_NONE)
	{
		int wing = m_map[8][2] + m_map[8][3] + m_map[8][4] + m_map[8][5] + m_map[8][6];
		if(wing == koma * 5)
			score -= 308;
	}
	if(m_map[8][1] == KOMA_NONE && m_map[8][2] == KOMA_NONE && m_map[8][8] == KOMA_NONE)
	{
		int wing = m_map[8][3] + m_map[8][4] + m_map[8][5] + m_map[8][6] + m_map[8][7];
		if(wing == koma * 5)
			score -= 308;
	}
	
	return score;
}

// 開放度：あるコマのまわり８箇所について、何もなければ後で返される可能性がある、つまりマイナス評価
int CComAI::calcOpen(KomaState koma)
{
	int score = 0;
	
	for(int x = 1; x <= 8; x++)
	{
		for(int y = 1; y <= 8; y++)
		{
			if(m_map[x][y] == koma)
			{
				for(int n = 0; n < 8; n++)
				{
					if(getKoma(x + m_addX[n], y + m_addY[n]) == KOMA_NONE)
						score -= 13;
				}
			}
		}
	}
	
	return score;
}

int CComAI::calcDoubleA(KomaState koma)
{
	int score = 0;
	int x, y;

	// 上辺
	if(getKoma(3, 1) == koma && getKoma(6, 1) == koma)
	{
		int total = 0;
		for(x = 1; x <= 8; x++)
			total += getKoma(x, 1);
		if(total == koma * 2)
			score += 200;
	}

	// 下辺
	if(getKoma(3, 8) == koma && getKoma(6, 8) == koma)
	{
		int total = 0;
		for(x = 1; x <= 8; x++)
			total += getKoma(x, 8);
		if(total == koma * 2)
			score += 200;
	}

	// 左辺
	if(getKoma(1, 3) == koma && getKoma(1, 6) == koma)
	{
		int total = 0;
		for(y = 1; y <= 8; y++)
			total += getKoma(1, y);
		if(total == koma * 2)
			score += 200;
	}

	// 右辺
	if(getKoma(8, 3) == koma && getKoma(8, 6) == koma)
	{
		int total = 0;
		for(y = 1; y <= 8; y++)
			total += getKoma(8, y);
		if(total == koma * 2)
			score += 200;
	}
	
	return score;
}

// 定石に置ける？
bool CComAI::isJouseki(CGPoint& retPos)
{
	int te = getNanteme();
	
	// １手目はここに決まってるらしぃ
	if(te == 1)
	{
		retPos.x = 6;
		retPos.y = 5;
		return true;
	}
	
	// ２手目の白は、横並びにならないように！（３個連続で縦・横に並ばなければOK）
	// ○○○
	// ●●● みたいになるとダメってこと。なので、凹んでる場所には打たないようにする
	if(te == 2)
	{
		vector<CGPoint> array;
		getCanPutPos(array);
		
		for(int p = 0; p < array.size(); p++)
		{
			int komaTotal = 0;
			for(int n = 0; n < 8; n++ )
			{
				CGPoint pos = array[p];
				if(getKoma(pos.x + m_addX[n], pos.y + m_addY[n]) != KOMA_NONE)
					komaTotal++;
			}
			
			// 置ける場所のまわりに３個以上のコマがある　→　つまりそこは凹んでる。そこい置くと３つずつ並ぶからNG
			if(komaTotal >= 3)
				continue;
			
			retPos = array[p];
			return true;
		}
	}
	
	if(te == 3)
	{
		int map[BOARD_X][BOARD_Y] =
		{
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,2,1,0,0,0},
			{0,0,0,2,1,1,0,0},
			{0,0,0,2,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
		};
		
		// 半分の確立で定石を分岐
		if(rand() % 2 == 0)
		{
			// 虎定石
			retPos = CGPointMake(3, 3);
			if(matchMap(map, retPos))
				return true;
		}
		else
		{
			// 兎定石
			retPos = CGPointMake(3, 5);
			if(matchMap(map, retPos))
				return true;
		}
	}
	
	if(te == 4)
	{
		// 虎定石
		int map[BOARD_X][BOARD_Y] =
		{
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,1,0,0,0,0,0},
			{0,0,0,1,1,0,0,0},
			{0,0,0,2,1,1,0,0},
			{0,0,0,2,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
		};
		
		retPos = CGPointMake(4, 3);
		if(matchMap(map, retPos))
			return true;
		
		// 兎定石
		int mapUsa[BOARD_X][BOARD_Y] =
		{
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,2,1,0,0,0},
			{0,0,1,1,1,1,0,0},
			{0,0,0,2,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
		};
		
		retPos = CGPointMake(6, 4);
		if(matchMap(mapUsa, retPos))
			return true;	
	}
	
	if(te == 5)
	{
		// 虎定石
		int map[BOARD_X][BOARD_Y] =
		{
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,1,2,0,0,0,0},
			{0,0,0,2,1,0,0,0},
			{0,0,0,2,1,1,0,0},
			{0,0,0,2,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
		};
		
		retPos = CGPointMake(3, 4);
		if(matchMap(map, retPos))
			return true;
		
		int mapUsaUma[BOARD_X][BOARD_Y] =
		{
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,2,2,2,0,0},
			{0,0,1,1,2,1,0,0},
			{0,0,0,2,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
		};
		
		// 半分の確立で定石を分岐
		if(rand() % 2 == 0)
		{
			// 兎定石
			retPos = CGPointMake(5, 3);
			if(matchMap(mapUsaUma, retPos))
				return true;
		}
		else
		{
			// 馬定石
			retPos = CGPointMake(4, 3);
			if(matchMap(mapUsaUma, retPos))
				return true;
		}
		
		int mapUshi[BOARD_X][BOARD_Y] =
		{
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,2,2,2,0,0},
			{0,0,0,1,1,2,0,0},
			{0,0,0,0,1,2,0,0},
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
		};
		
		// 半分の確立で定石を分岐
		if(rand() % 2 == 0)
		{
			// バッファロー定石
			retPos = CGPointMake(3, 3);
			if(matchMap(mapUshi, retPos))
				return true;
		}
		else
		{
			// 牛定石
			retPos = CGPointMake(5, 3);
			if(matchMap(mapUshi, retPos))
				return true;
		}
	}
	
	return false;
}

// 引数のmapに一致するか否か。retPosには次の１手が保持されているので、回転などするなら変換して返すこと
bool CComAI::matchMap(int pmap[BOARD_X][BOARD_Y], CGPoint &retPos)
{
	bool match = true;
	CGPoint pos = retPos;	// 変換元を保持
	int x, y;
	
	// @todo これを不要にしたい
	// ※２次元配列を引数渡しすると、X,Yがひっくり返るので元に戻すのです。。。
	int map[BOARD_X][BOARD_Y];
	for(x = 0; x < BOARD_X; x++)
	{
		for(y = 0; y < BOARD_Y; y++)
		{
			map[x][y] = pmap[y][x];
		}
	}
	
	// そのまま比較
	for(x = 0; x < BOARD_X && match; x++)
	{
		for(y = 0; y < BOARD_Y && match; y++)
		{
			if(getKoma(x+1, y+1) != map[x][y])
			{
				match = false;
				break;
			}
		}
	}
	if(match)
	{
		return true;
	}
	
	// 右９０度回転、左右反転して比較
	match = true;
	for(x = 0; x < BOARD_X && match; x++)
	{
		for(y = 0; y < BOARD_Y && match; y++)
		{
			if(getKoma(x+1, y+1) != map[y][x])
			{
				match = false;
				break;
			}
		}
	}
	if(match)
	{
		retPos.x = pos.y;
		retPos.y = pos.x;
		return true;
	}
	
	// 右２回転して比較
	match = true;
	for(x = 0; x < BOARD_X && match; x++)
	{
		for(y = 0; y < BOARD_Y && match; y++)
		{
			if(getKoma(x+1, y+1) != map[BOARD_X - x - 1][BOARD_Y - y - 1])
			{
				match = false;
				break;
			}
		}
	}
	if(match)
	{
		retPos.x = BOARD_X - pos.x + 1;
		retPos.y = BOARD_Y - pos.y + 1;
		return true;
	}
	
	// 左１回転、左右反転して比較
	match = true;
	for(x = 0; x < BOARD_X && match; x++)
	{
		for(y = 0; y < BOARD_Y && match; y++)
		{
			if(getKoma(x+1, y+1) != map[BOARD_Y - y - 1][BOARD_X - x - 1])
			{
				match = false;
				break;
			}
		}
	}
	if(match)
	{
		retPos.x = BOARD_Y - pos.y + 1;
		retPos.y = BOARD_X - pos.x + 1;
		return true;
	}
	
	return false;
}
