//
//  SampleForModal.m
//
//  Created by ToKoRo on 2009-08-16.
//

#import "Config.h"

@implementation ConfigDialog
/*
- (void)unko:(CBoard*)board
{
	board->m_bMarker = !board->m_bMarker;
}
*/

- (id)init:(CBoard*)board {
    if (self=[super init]) {
		m_board = board;
    }
    return self;
}

- (void)viewDidLoad {
  [super viewDidLoad];
	
	// 設定Load
	NSUserDefaults* def = [NSUserDefaults standardUserDefaults];

	NSArray* players = [NSArray arrayWithObjects:@"Player", @"COM", nil];
	
	// Black
	UILabel* labelBlack = [[[UILabel alloc] initWithFrame:CGRectMake(0,0,80,30)] autorelease];
	labelBlack.backgroundColor = [UIColor blackColor];
	labelBlack.textColor = [UIColor whiteColor];
	labelBlack.textAlignment = UITextAlignmentCenter;
	labelBlack.text = @"Black";
	[self.view addSubview:labelBlack];

	m_segmentBlack = [[[UISegmentedControl alloc] initWithItems:players] autorelease];
//	m_segmentBlack.selectedSegmentIndex = m_board->m_playersBlack == PLAYERS_PLAYER ? 0 : 1;
	m_segmentBlack.selectedSegmentIndex = [def boolForKey:CONFIG_ISBLACKPLAYER] ? 0 : 1;
	m_segmentBlack.frame = CGRectMake(100, 0, 130, 30);
	[self.view addSubview:m_segmentBlack];

	// White
	UILabel* labelWhite = [[[UILabel alloc] initWithFrame:CGRectMake(0,40,80,30)] autorelease];
	labelWhite.backgroundColor = [UIColor blackColor];
	labelWhite.textColor = [UIColor whiteColor];
	labelWhite.textAlignment = UITextAlignmentCenter;
	labelWhite.text = @"White";
	[self.view addSubview:labelWhite];

	m_segmentWhite = [[[UISegmentedControl alloc] initWithItems:players] autorelease];
//	m_segmentWhite.selectedSegmentIndex = m_board->m_playersWhite == PLAYERS_PLAYER ? 0 : 1;
	m_segmentWhite.selectedSegmentIndex = [def boolForKey:CONFIG_ISWHITEPLAYER] ? 0 : 1;
	m_segmentWhite.frame = CGRectMake(100, 40, 130, 30);
	[self.view addSubview:m_segmentWhite];
	
	// Marker
	UILabel* labelMarker = [[[UILabel alloc] initWithFrame:CGRectMake(0,80,80,30)] autorelease];
	labelMarker.backgroundColor = [UIColor blackColor];
	labelMarker.textColor = [UIColor whiteColor];
	labelMarker.textAlignment = UITextAlignmentCenter;
	labelMarker.text = @"Marker";
	[self.view addSubview:labelMarker];
	
	m_switchMarker = [[[UISwitch alloc] initWithFrame:CGRectMake(100, 80, 130, 30)] autorelease];
//	m_switchMarker.on = m_board->m_bMarker ? YES : NO;
	m_switchMarker.on = [def boolForKey:CONFIG_MARKER] ? YES : NO;
	[self.view addSubview:m_switchMarker];

	
  // 閉じるボタンを追加
  UIButton* goodbyeButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  [goodbyeButton setTitle:@"OK" forState:UIControlStateNormal];
  [goodbyeButton sizeToFit];
  CGPoint newPoint = self.view.center;
  newPoint.y += 80;
  goodbyeButton.center = newPoint;
  [goodbyeButton addTarget:self
                    action:@selector(goodbyeDidPush)
          forControlEvents:UIControlEventTouchUpInside];
  [self.view addSubview:goodbyeButton];
}

- (void)goodbyeDidPush {
  // モーダルダイアログを閉じる
  [self dismissModalViewControllerAnimated:YES];
	
	NSUserDefaults* def = [NSUserDefaults standardUserDefaults];
	[def setBool:m_segmentBlack.selectedSegmentIndex == 0 forKey:CONFIG_ISBLACKPLAYER];
	[def setBool:m_segmentWhite.selectedSegmentIndex == 0 forKey:CONFIG_ISWHITEPLAYER];
	[def setBool:[m_switchMarker isOn] forKey:CONFIG_MARKER];

	if(![def synchronize])
	{
		NSLog(@"SaveConfig NG");
	}
	
	m_board->loadConfig();
}

@end
