//
//  EAGLView.h
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <OpenGLES/EAGL.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>
#import "Board.h"

//EAGLViewの実装
@interface EAGLView : UIView {    
@private
    EAGLContext*   _context;        //コンテキスト
    GLint          _backWidth;      //バックバッファの幅
    GLint          _backHeight;     //バックバッファの高さ
    GLuint         _viewRenderBuff; //レンダーバッファ
    GLuint         _viewFrameBuff;  //フレームバッファ
    GLuint         _depthRenderBuff;//デプスレンダーバッファ
    NSTimer*       _animeTimer;     //アニメーションタイマー
    NSTimeInterval _animeInterval;  //アニメーションインターバル
    BOOL           _initFlag;       //初期化フラグ
	
@protected
	UIViewController*	_ctrl;
	UIToolbar*			tb;
	CBoard				board;
}

//プロパティ
@property(readonly) GLint backWidth;
@property(readonly) GLint backHeight;
@property NSTimeInterval animeInterval;
@property(assign) UIViewController* ctrl;

//メソッド
- (void)startAnimation;
- (void)stopAnimation;
- (void)setup;
- (void)draw;
//- (void)saveGame;
@end