//
//  EAGLView.m
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import <OpenGLES/EAGLDrawable.h>
#import "EAGLView.h"
#import "Config.h"

#define USE_DEPTH_BUFFER 0

//EAGLViewのプライベートメソッド
@interface EAGLView ()
@property (nonatomic,retain) EAGLContext* context;
@property (nonatomic,assign) NSTimer* animeTimer;
- (BOOL)createFrameBuff;
- (void)destroyFrameBuff;
- (void)drawView;
@end


//EAGLViewの実装
@implementation EAGLView

//シンセサイズ
@synthesize context=_context;
@synthesize animeTimer=_animeTimer;
@synthesize backWidth=_backWidth;
@synthesize backHeight=_backHeight;
@synthesize animeInterval=_animeInterval;
@synthesize ctrl=_ctrl;

- (void)actionSheet:(UIActionSheet*)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex
{
	if(buttonIndex != actionSheet.cancelButtonIndex)
	{
		NSLog(@"push");
		board.NewGame();
	}
}

- (void)onMenu
{
	UIActionSheet* sheet = [[[UIActionSheet alloc] init] autorelease];
	sheet.delegate = self;
	
	[sheet addButtonWithTitle:@"New Game"];
	[sheet addButtonWithTitle:@"Cancel"];
	
	sheet.cancelButtonIndex = 1;
	
	sheet.actionSheetStyle = UIActionSheetStyleBlackTranslucent;
	
	// @todo:toolbarを差したらいいかもね
	[sheet showFromToolbar:self.superview];
}

- (void)onBack
{
	if(board.back())
	{
		UIBarButtonItem* item = [tb.items objectAtIndex:1];
		item.enabled = YES;
	}
}

- (void)onForward
{
	if(board.forward())
	{
		UIBarButtonItem* item = [tb.items objectAtIndex:1];
		item.enabled = YES;
	}
}

- (void)onPlay
{
	board.play();
	
	UIBarButtonItem* item = [tb.items objectAtIndex:1];
	item.enabled = NO;
}

- (void)onConfig
{
	// モーダルダイアログの表示
	ConfigDialog* dialog = [[[ConfigDialog alloc] init:&board] autorelease];
	
	// 水平方向に回転
	dialog.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
//	[dialog unko:&board];
	[_ctrl presentModalViewController:dialog animated:YES];
}

//レイヤーの取得
+ (Class)layerClass {
    return [CAEAGLLayer class];
}

//初期化
- (id)init {
    if ((self=[super init])) {
        _initFlag=NO;
    }
    return self;
}

//フレームの初期化
- (id)initWithFrame:(CGRect)frame{
    if (self=[super initWithFrame:frame]) {
        //レイヤーの生成
        CAEAGLLayer* eaglLayer=(CAEAGLLayer*)self.layer;
        eaglLayer.opaque=YES;
        eaglLayer.drawableProperties=[NSDictionary dictionaryWithObjectsAndKeys:
									  [NSNumber numberWithBool:NO], 
									  kEAGLDrawablePropertyRetainedBacking, 
									  kEAGLColorFormatRGBA8, 
									  kEAGLDrawablePropertyColorFormat, 
									  nil];
        
        //コンテキストの生成
        _context=[[EAGLContext alloc] initWithAPI:kEAGLRenderingAPIOpenGLES1];
        if (!_context || ![EAGLContext setCurrentContext:_context]) {
            [self release];
            return nil;
        }
        
        //アニメーションインターバルの指定
        _animeInterval=1.0f/60.0f;
		
		// ツールバー		
		tb = [[UIToolbar alloc] initWithFrame:CGRectMake(0, 420, 320, 40)];

		UIBarButtonItem* button0 = [[[UIBarButtonItem alloc] initWithTitle:@"Menu" style:UIBarButtonItemStyleBordered target:self action:@selector(onMenu)] autorelease];
		
		UIBarButtonItem* button1 = [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemRewind  target:self action:@selector(onBack)] autorelease];
		
		UIBarButtonItem* button2 = [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemPlay  target:self action:@selector(onPlay)] autorelease];
		button2.enabled = NO;
		
		UIBarButtonItem* button3 = [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFastForward  target:self action:@selector(onForward)] autorelease];

		UIBarButtonItem* button4 = [[[UIBarButtonItem alloc] initWithTitle:@"Config" style:UIBarButtonItemStyleBordered target:self action:@selector(onConfig)] autorelease];
		
		UIBarButtonItem* space = [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFixedSpace target:nil action:nil] autorelease];
		space.width = 114;
		
		NSArray* buttons = [NSArray arrayWithObjects:button0, button1, button2, button3, space, button4, nil];
		[tb setItems:buttons animated:YES];
		tb.barStyle = UIBarStyleBlack;
		[self addSubview:tb];		
		
	}
    return self;
}

//メモリの解放
- (void)dealloc {    
    [self stopAnimation];    
    if ([EAGLContext currentContext]==_context) {
        [EAGLContext setCurrentContext:nil];
    }    
    [_context release];  
    [super dealloc];
}

//ビューの描画
- (void)drawView {
    //前処理
    [EAGLContext setCurrentContext:_context];
    glBindFramebufferOES(GL_FRAMEBUFFER_OES,_viewFrameBuff);
	
    //描画
    if (!_initFlag) {
        [self setup];
        _initFlag=YES;
    }
    [self draw];
	
    //後処理
    glBindRenderbufferOES(GL_RENDERBUFFER_OES,_viewRenderBuff);
    [_context presentRenderbuffer:GL_RENDERBUFFER_OES];
}

//セットアップ(オーバーライド用)
- (void)setup {
}

//描画(オーバーライド用)
- (void)draw {
}

//- (void)saveGame
//{
//	board.saveGame();
//}

//サブビューのレイアウト
- (void)layoutSubviews {
    [EAGLContext setCurrentContext:_context];
    [self destroyFrameBuff];
    [self createFrameBuff];
    [self drawView];
}

//フレームバッファの生成
- (BOOL)createFrameBuff {
    glGenFramebuffersOES(1,&_viewFrameBuff);
    glGenRenderbuffersOES(1,&_viewRenderBuff);
    glBindFramebufferOES(GL_FRAMEBUFFER_OES,_viewFrameBuff);
    glBindRenderbufferOES(GL_RENDERBUFFER_OES,_viewRenderBuff);
    [_context renderbufferStorage:GL_RENDERBUFFER_OES fromDrawable:(CAEAGLLayer*)self.layer];
    glFramebufferRenderbufferOES(GL_FRAMEBUFFER_OES,GL_COLOR_ATTACHMENT0_OES,GL_RENDERBUFFER_OES,_viewRenderBuff);   
    glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES,GL_RENDERBUFFER_WIDTH_OES,&_backWidth);
    glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES,GL_RENDERBUFFER_HEIGHT_OES,&_backHeight);
    if (USE_DEPTH_BUFFER) {
        glGenRenderbuffersOES(1,&_depthRenderBuff);
        glBindRenderbufferOES(GL_RENDERBUFFER_OES,_depthRenderBuff);
        glRenderbufferStorageOES(GL_RENDERBUFFER_OES,GL_DEPTH_COMPONENT16_OES,_backWidth,_backHeight);
        glFramebufferRenderbufferOES(GL_FRAMEBUFFER_OES,GL_DEPTH_ATTACHMENT_OES,GL_RENDERBUFFER_OES,_depthRenderBuff);
    }
    if(glCheckFramebufferStatusOES(GL_FRAMEBUFFER_OES)!=GL_FRAMEBUFFER_COMPLETE_OES) {
        return NO;
    }
    return YES;
}

//フレームバッファの破棄
- (void)destroyFrameBuff {    
    glDeleteFramebuffersOES(1,&_viewFrameBuff);
    _viewFrameBuff=0;
    glDeleteRenderbuffersOES(1,&_viewRenderBuff);
    _viewRenderBuff=0;    
    if (_depthRenderBuff) {
        glDeleteRenderbuffersOES(1,&_depthRenderBuff);
        _depthRenderBuff=0;
    }
}

//アニメーションの開始
- (void)startAnimation {
    self.animeTimer=[NSTimer scheduledTimerWithTimeInterval:_animeInterval 
													 target:self selector:@selector(drawView)userInfo:nil repeats:YES];
}

//アニメーションの停止
- (void)stopAnimation {
    self.animeTimer=nil;
}

//アニメーションタイマーの指定
- (void)setanimeTimer:(NSTimer*)newTimer {
    [_animeTimer invalidate];
    _animeTimer=newTimer;
}

//アニメーションインターバルの指定
- (void)setanimeInterval:(NSTimeInterval)interval {
    _animeInterval=interval;
    if (_animeTimer) {
        [self stopAnimation];
        [self startAnimation];
    }
}

// 画面をタッチ
- (void)touchesBegan:(NSSet*)touches withEvent:(UIEvent*)event
{
	CGPoint pt = [[touches anyObject] locationInView:self];
	
	board.m_pointer = pt;
	
	if(board.m_gameState == GAME_READY)
	{
		board.m_gameState = GAME_SELECTING;
	}
}

// タッチしたまま移動
- (void)touchesMoved:(NSSet*)touches withEvent:(UIEvent*)event
{
	CGPoint pt = [[touches anyObject] locationInView:self];
//	NSLog(@"move %d, %d", (int)pt.x, (int)pt.y);
	board.m_pointer = pt;
}

// 指を離した
- (void)touchesEnded:(NSSet*)touches withEvent:(UIEvent*)event
{
	CGPoint pt = [[touches anyObject] locationInView:self];
//	NSLog(@"ended %d, %d", (int)pt.x, (int)pt.y);
	board.m_pointer = pt;

	int x = (pt.x - MARGIN_X) / KOMA_SIZE + 1;
	int y = (pt.y - MARGIN_Y) / KOMA_SIZE + 1;
	board.put(x, y);
	
	board.m_gameState = GAME_READY;
}
@end