//
//  Graphics2D.h
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "Texture.h"

//Graphics2Dの宣言
@interface Graphics2D : NSObject {
@private
    //サイズ
    CGSize _backSize;//背景サイズ
	
    //色
    GLbyte _colR;//赤
    GLbyte _colG;//緑
    GLbyte _colB;//青
    GLbyte _colA;//α
	
    //ワーク
    GLfloat* _vertexs;//頂点
    GLbyte*  _colors; //色
}

//初期化
- (void)setup:(CGSize)backSize;

//アクセス
- (void)clear;
- (void)clipRectX:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h;
- (void)clearClip;
- (void)setLineWidth:(GLfloat)lineWidth;
- (void)setColorR:(float)r g:(float)g b:(float)b a:(float)a;
- (void)setColorR:(float)r g:(float)g b:(float)b;
- (void)setTranslateX:(GLfloat)transX y:(GLfloat)transY;
- (void)setRotate:(GLfloat)rotate;
- (void)setScaleW:(GLfloat)scaleW h:(GLfloat)scaleH;
- (void)pushMatrix;
- (void)popMatrix;

//描画
- (void)drawLineX0:(GLfloat)x0 y0:(GLfloat)y0 x1:(GLfloat)x1 y1:(GLfloat)y1;
- (void)drawPolyline:(CGPoint[])pos length:(GLint)length;
- (void)drawRectX:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h;
- (void)fillRectX:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h;
- (void)drawCircleX:(GLfloat)x y:(GLfloat)y r:(GLfloat)r;
- (void)fillCircleX:(GLfloat)x y:(GLfloat)y r:(GLfloat)r;
- (void)drawTriangle:(CGPoint[])pos;
- (void)fillTriangle:(CGPoint[])pos;
- (void)drawTexture:(Texture*)texture x:(GLfloat)x y:(GLfloat)y;
- (void)drawTexture:(Texture*)texture x:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h;
@end

