//
//  Graphics2D.m
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "Graphics2D.h"

//テクスチャ頂点情報
GLfloat panelVertices[]={
0,  0, //左上
0, -1, //左下
1,  0, //右上
1, -1, //右下
};

//テクスチャUV情報
const GLfloat panelUVs[]={
0.0f, 0.0f, //左上
0.0f, 1.0f, //左下
1.0f, 0.0f, //右上
1.0f, 1.0f, //右下
};

//Graphics2Dの実装
@implementation Graphics2D

//====================
//初期化
//====================
//初期化
- (id)init {
    if (self=[super init]) {
        //サイズ
        _backSize=CGSizeMake(320,460);
		
        //色
        _colR=0;
        _colG=0;
        _colB=0;
        _colA=255;
		
        //ワーク
        _vertexs=(GLfloat*)malloc(256*3*sizeof(GLfloat));
        _colors=(GLbyte*)malloc(256*4*sizeof(GLbyte));
    }
    return self;
}

//メモリ解放
- (void)dealloc {
    free(_vertexs);
    free(_colors);
    [super dealloc];
}

//セットアップ
- (void)setup:(CGSize)backSize {    
    _backSize=backSize;
	
    //ビューポート変換
    glViewport(0,0,_backSize.width,_backSize.height);
    
    //投影変換
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrthof(-_backSize.width/2,_backSize.width/2,
			 -_backSize.height/2,_backSize.height/2,-100,100);    
    glTranslatef(-_backSize.width/2,_backSize.height/2,0);
    
    //モデリング変換    
    glMatrixMode(GL_MODELVIEW);
	
    //クリア色の設定
    glClearColor(1,1,1,1);
    
    //頂点配列の設定
    glVertexPointer(2,GL_FLOAT,0,panelVertices);
    glEnableClientState(GL_VERTEX_ARRAY);
    
    //UVの設定
    glTexCoordPointer(2,GL_FLOAT,0,panelUVs);
	
    //テクスチャの設定
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
    glEnable(GL_TEXTURE_2D);
	
    //ブレンドの設定
    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
	
    //ポイントの設定
    glEnable(GL_POINT_SMOOTH);
}

//====================
//アクセス
//====================
//クリア
- (void)clear {
    glClear(GL_COLOR_BUFFER_BIT); 
}

//クリッピングの指定
- (void)clipRectX:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h {
    GLfloat area0[4]={ 0,-1, 0,-y  };
    GLfloat area1[4]={ 0, 1, 0, y+h};
    GLfloat area2[4]={ 1, 0, 0,-x  };
    GLfloat area3[4]={-1, 0, 0, x+h};
    glClipPlanef(GL_CLIP_PLANE0,area0);
    glClipPlanef(GL_CLIP_PLANE1,area1);
    glClipPlanef(GL_CLIP_PLANE2,area2);
    glClipPlanef(GL_CLIP_PLANE3,area3);
    glEnable(GL_CLIP_PLANE0);
    glEnable(GL_CLIP_PLANE1);
    glEnable(GL_CLIP_PLANE2);
    glEnable(GL_CLIP_PLANE3);
}

//クリッピングのクリア
- (void)clearClip {
    glDisable(GL_CLIP_PLANE0);
    glDisable(GL_CLIP_PLANE1);
    glDisable(GL_CLIP_PLANE2);
    glDisable(GL_CLIP_PLANE3);
}

//ライン幅の指定
- (void)setLineWidth:(GLfloat)lineWidth {
    glLineWidth(lineWidth);
    glPointSize(lineWidth*0.6);
}

//色の指定
- (void)setColorR:(float)r g:(float)g b:(float)b a:(float)a {
    _colR=r;
    _colG=g;
    _colB=b;
    _colA=a;
}

//色の指定
- (void)setColorR:(float)r g:(float)g b:(float)b {
    [self setColorR:r g:g b:b a:255];
}

//平行移動の指定　
- (void)setTranslateX:(GLfloat)transX y:(GLfloat)transY {
    glTranslatef(transX,-transY,0);
}

//回転角度の指定
- (void)setRotate:(GLfloat)rotate {
    glRotatef(rotate*(-180)/M_PI,0,0,1);
}

//スケールの指定
- (void)setScaleW:(GLfloat)scaleW h:(GLfloat)scaleH {
    glScalef(scaleW,scaleH,1);
}

//行列のプッシュ
- (void)pushMatrix {
    glPushMatrix();
}

//行列のポップ
- (void)popMatrix {
    glPopMatrix();
}

//====================
//描画
//====================
//ラインの描画
- (void)drawLineX0:(GLfloat)x0 y0:(GLfloat)y0 x1:(GLfloat)x1 y1:(GLfloat)y1 {
	//頂点配列情報
	_vertexs[0]= x0;_vertexs[1]=-y0;_vertexs[2]=0;
	_vertexs[3]= x1;_vertexs[4]=-y1;_vertexs[5]=0;     
	
	//カラー配列情報
	for (int i=0;i<2;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_LINE_STRIP,0,2);
    glPopMatrix();
}

//ポリラインの描画
- (void)drawPolyline:(CGPoint[])pos length:(GLint)length {
	//頂点配列情報
	for (int i=0;i<length;i++) {
		_vertexs[i*3+0]= pos[i].x;
		_vertexs[i*3+1]=-pos[i].y;
		_vertexs[i*3+2]=0;
	}
	
	//カラー配列情報
	for (int i=0;i<length;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_LINE_STRIP,0,length);
	glDrawArrays(GL_POINTS,0,length);
    glPopMatrix();
}

//矩形の描画
- (void)drawRectX:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h {
	//頂点配列情報
	_vertexs[0]= x;  _vertexs[1] =-y;  _vertexs[2] =0;
	_vertexs[3]= x;  _vertexs[4] =-y-h;_vertexs[5] =0;  
	_vertexs[6]= x+w;_vertexs[7] =-y-h;_vertexs[8] =0;
	_vertexs[9]= x+w;_vertexs[10]=-y;  _vertexs[11]=0;  
	
	//カラー配列情報
	for (int i=0;i<4;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_LINE_LOOP,0,4);
	glDrawArrays(GL_POINTS,0,4);
    glPopMatrix();
}

//矩形の塗り潰し
- (void)fillRectX:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h {
	//頂点配列情報
	_vertexs[0]= x;  _vertexs[1] =-y;  _vertexs[2] =0;
	_vertexs[3]= x;  _vertexs[4] =-y-h;_vertexs[5] =0;  
	_vertexs[6]= x+w;_vertexs[7] =-y;  _vertexs[8] =0;
	_vertexs[9]= x+w;_vertexs[10]=-y-h;_vertexs[11]=0;  
	
	//カラー配列情報
	for (int i=0;i<4;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //三角形の描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_TRIANGLE_STRIP,0,4);
    glPopMatrix();
}

//円の描画
- (void)drawCircleX:(GLfloat)x y:(GLfloat)y r:(GLfloat)r {
    int length=100;
    
	//頂点配列情報
	for (int i=0;i<length;i++) {
		float angle=2*M_PI*i/length;
		_vertexs[i*3+0]= x+cos(angle)*r;
		_vertexs[i*3+1]=-y+sin(angle)*r;
		_vertexs[i*3+2]=0;
	}
	
	//カラー配列情報
	for (int i=0;i<length;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_LINE_LOOP,0,length);
	glDrawArrays(GL_POINTS,0,length);
    glPopMatrix();
}

//円の塗り潰し
- (void)fillCircleX:(GLfloat)x y:(GLfloat)y r:(GLfloat)r {
    int length=100+2;
    
	//頂点配列情報
	_vertexs[0]= x;
	_vertexs[1]=-y;
	_vertexs[2]=0;
	for (int i=1;i<length;i++) {
		float angle=2*M_PI*i/(length-2);
		_vertexs[i*3+0]= x+cos(angle)*r;
		_vertexs[i*3+1]=-y+sin(angle)*r;
		_vertexs[i*3+2]=0;
	}
	
	//カラー配列情報
	for (int i=0;i<length;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_TRIANGLE_FAN,0,length);
    glPopMatrix();
}

//三角形の描画
- (void)drawTriangle:(CGPoint[])pos {
	//頂点配列情報
	int length=3;
	for (int i=0;i<length;i++) {
		_vertexs[i*3+0]= pos[i].x;
		_vertexs[i*3+1]=-pos[i].y;
		_vertexs[i*3+2]=0;
	}
	
	//カラー配列情報
	for (int i=0;i<length;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_LINE_LOOP,0,length);
	glDrawArrays(GL_POINTS,0,length);
    glPopMatrix();
}

//三角形の塗り潰し
- (void)fillTriangle:(CGPoint[])pos {
	//頂点配列情報
	int length=3;
	for (int i=0;i<length;i++) {
		_vertexs[i*3+0]= pos[i].x;
		_vertexs[i*3+1]=-pos[i].y;
		_vertexs[i*3+2]=0;
	}
	
	//カラー配列情報
	for (int i=0;i<length;i++) {
		_colors[i*4  ]=_colR;
		_colors[i*4+1]=_colG;
		_colors[i*4+2]=_colB;
		_colors[i*4+3]=_colA;
	}
	
    //ラインの描画
    glBindTexture(GL_TEXTURE_2D,0);
    glEnableClientState(GL_COLOR_ARRAY);
    glVertexPointer(3,GL_FLOAT,0,_vertexs);
    glColorPointer(4,GL_UNSIGNED_BYTE,0,_colors);
    glPushMatrix();
	glDrawArrays(GL_LINE_LOOP,0,length);
	glDrawArrays(GL_TRIANGLES,0,length);
	glDrawArrays(GL_POINTS,0,length);
    glPopMatrix();
}

//テクスチャの描画
- (void)drawTexture:(Texture*)texture x:(GLfloat)x y:(GLfloat)y {
    glBindTexture(GL_TEXTURE_2D,texture.name);
    glVertexPointer(2,GL_FLOAT,0,panelVertices);
    glDisableClientState(GL_COLOR_ARRAY);
    glPushMatrix();
	glTranslatef(x,-y,0);
	glScalef(texture.width,texture.height,1);
	glDrawArrays(GL_TRIANGLE_STRIP,0,4);
    glPopMatrix();
}

//テクスチャの描画
- (void)drawTexture:(Texture*)texture x:(GLfloat)x y:(GLfloat)y w:(GLfloat)w h:(GLfloat)h {
    glBindTexture(GL_TEXTURE_2D,texture.name);
    glVertexPointer(2,GL_FLOAT,0,panelVertices);
    glDisableClientState(GL_COLOR_ARRAY);
    glPushMatrix();
	glTranslatef(x,-y,0);
	glScalef(w,h,1);
	glDrawArrays(GL_TRIANGLE_STRIP,0,4);
    glPopMatrix();
}
@end