//
//  Graphics2DEx.m
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "Graphics2DEx.h"

//Graphics2DExの実装
@implementation Graphics2DEx

//フレームの初期化
- (id)initWithFrame:(CGRect)frame {
    if (self=[super initWithFrame:frame]) {	
		
        //グラフィックスの生成
        _g=[[Graphics2D alloc] init];
        
        //テクスチャの初期化
        textureBack = nil;
        textureBlack = nil;
        textureWhite = nil;
		textureMarker = nil;
		textureLastKomaPos = nil;
		textureSelection = nil;
		textureCursorX = nil;
		textureCursorY = nil;
		textureIconBlack = nil;
		textureIconWhite = nil;
		textureNum[0] = nil;
		textureNum[1] = nil;
		textureNum[2] = nil;
		textureNum[3] = nil;
		textureNum[4] = nil;
		textureNum[5] = nil;
		textureNum[6] = nil;
		textureNum[7] = nil;
		textureNum[8] = nil;
		textureNum[9] = nil;
        
        //アニメーションの開始
        [self startAnimation];
    }
    return self;
}

//メモリ解放
- (void)dealloc {
    [_g release];
	
    [textureBack release];
    [textureBlack release];
    [textureWhite release];
	[textureMarker release];
	[textureLastKomaPos release];
	[textureSelection release];
	[textureCursorX release];
	[textureCursorY release];
	[textureIconBlack release];
	[textureIconWhite release];
	[textureNum[0] release];
	[textureNum[1] release];
	[textureNum[2] release];
	[textureNum[3] release];
	[textureNum[4] release];
	[textureNum[5] release];
	[textureNum[6] release];
	[textureNum[7] release];
	[textureNum[8] release];
	[textureNum[9] release];
	
    [super dealloc];
}

//セットアップ
- (void)setup {
	
	//グラフィックスのセットアップ    
    [_g setup:CGSizeMake(self.backWidth,self.backHeight)];
/*	
    //テクスチャの読み込み
    _texture0=[[Texture makeTexture:[UIImage imageNamed:@"01_pieace_a.png"]] retain];
    _texture1=[[Texture makeTexture:[UIImage imageNamed:@"back.png"]] retain];
    _texture2=[[Texture makeTextTexture:@"そらみ"
								   font:[UIFont boldSystemFontOfSize:24] 
								  color:[UIColor blueColor]
								bgcolor:[UIColor clearColor]] retain];
*/

    textureBack =[[Texture makeTexture:[UIImage imageNamed:@"back.png"]] retain];
    textureBlack=[[Texture makeTexture:[UIImage imageNamed:@"komaBlack.png"]] retain];
    textureWhite=[[Texture makeTexture:[UIImage imageNamed:@"komaWhite.png"]] retain];
	textureMarker=[[Texture makeTexture:[UIImage imageNamed:@"marker.png"]] retain];
	textureLastKomaPos=[[Texture makeTexture:[UIImage imageNamed:@"lastkoma.png"]] retain];
	textureSelection=[[Texture makeTexture:[UIImage imageNamed:@"marker.png"]] retain];
	textureCursorX=[[Texture makeTexture:[UIImage imageNamed:@"cursor_x.png"]] retain];
	textureCursorY=[[Texture makeTexture:[UIImage imageNamed:@"cursor_y.png"]] retain];
	textureIconBlack=[[Texture makeTexture:[UIImage imageNamed:@"icoBlack.png"]] retain];
	textureIconWhite=[[Texture makeTexture:[UIImage imageNamed:@"icoWhite.png"]] retain];
	
	UIFont* font = [UIFont fontWithName:@"Helvetica-Bold" size:48];
	for(int n = 0; n < 10; n++)
	{
		NSString* text = [NSString stringWithFormat:@"%d", n];
		textureNum[n] = [[Texture makeTextTexture:text
//											 font:[UIFont boldSystemFontOfSize:fontsize] 
											 font:font
											color:[UIColor whiteColor]
										  bgcolor:[UIColor clearColor]] retain];
	}
}

//描画
- (void)draw {
	// ゲーム進行
	board.update();
		
    //バッファのクリア
    [_g clear];
	
    //画像の描画    
    [_g drawTexture:textureBack x:0 y:0];
	
	// icon
	[_g drawTexture:textureIconBlack x:0 y:0];
	[_g drawTexture:textureIconWhite x:240 y:0];
	
	int x, y;
	for(x = 1; x <= BOARD_X; x++)
	{
		for(y = 1; y <= BOARD_Y; y++)
		{
			if(board.m_map[x][y] == KOMA_BLACK)
			{
				[_g drawTexture:textureBlack x:(x-1)*KOMA_SIZE + MARGIN_X - 14 y:(y-1)*KOMA_SIZE + MARGIN_Y- 14 ];
			}
			else if(board.m_map[x][y] == KOMA_WHITE)
			{
				[_g drawTexture:textureWhite x:(x-1)*KOMA_SIZE + MARGIN_X - 14 y:(y-1)*KOMA_SIZE + MARGIN_Y - 14 ];
			}
		}
	}

	// マーカー
	if(board.m_bMarker)
	{
		if(board.m_gameState == GAME_READY || board.m_gameState == GAME_SELECTING)
		{
			vector<CGPoint> arrayMarker;
			board.getCanPutPos(arrayMarker);
			for(int n = 0; n < arrayMarker.size(); n++)
			{
				CGPoint pos = arrayMarker[n];
				[_g drawTexture:textureMarker x:(pos.x-1)*KOMA_SIZE + MARGIN_X y:(pos.y-1)*KOMA_SIZE + MARGIN_Y];
			}
		}
	}
	
	// 最後に置いたコマ
	if(board.getNanteme() > 1)
	{
		[_g drawTexture:textureLastKomaPos x:(board.m_lastKomaPos.x-1)*KOMA_SIZE + MARGIN_X - 14 y:(board.m_lastKomaPos.y-1)*KOMA_SIZE + MARGIN_Y- 14 ];
	}
	
	// カーソル
	if(board.m_gameState == GAME_SELECTING)
	{
		CGPoint pos;
		if(board.getKomaPos(pos))
		{
			[_g drawTexture:textureCursorY x:MARGIN_X y:(pos.y-1)*KOMA_SIZE + MARGIN_Y];
			[_g drawTexture:textureCursorX x:(pos.x-1)*KOMA_SIZE + MARGIN_X y:MARGIN_Y];
/*			
			for(x = 1; x <= BOARD_X; x++)
				[_g drawTexture:textureMarker x:(x-1)*KOMA_SIZE + MARGIN_X y:(pos.y-1)*KOMA_SIZE + MARGIN_Y];
			for(y = 1; y <= BOARD_Y; y++)
				[_g drawTexture:textureMarker x:(pos.x-1)*KOMA_SIZE + MARGIN_X y:(y-1)*KOMA_SIZE + MARGIN_Y];
 */
		}
	}
	
	// コマ数
	int ten, one;
	
	int white, black;
	board.getKomaTotal(black, white);

	ten = black / 10;
	one = black % 10;
	[_g drawTexture:textureNum[ten] x:82 y:12];
	[_g drawTexture:textureNum[one] x:106 y:12];

	ten = white / 10;
	one = white % 10;
	[_g drawTexture:textureNum[ten] x:188 y:12];
	[_g drawTexture:textureNum[one] x:212 y:12];
}
@end