//
//  Texture.h
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <OpenGLES/EAGL.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>
#import <QuartzCore/QuartzCore.h>
#import "Util.h"

//Textureの宣言
@interface Texture : NSObject {
    unsigned char* _data;
    GLuint         _name;
    GLsizei        _width;
    GLsizei        _height;
}

//プロパティ
@property unsigned char* data;
@property GLuint name;
@property GLsizei width;
@property GLsizei height;

//テクスチャの生成
+ (Texture*)makeTexture:(UIImage*)image;

//テキストテクスチャ
+ (Texture*)makeTextTexture:(NSString*)text font:(UIFont*)font 
					  color:(UIColor*)color bgcolor:(UIColor*)bgcolor;
+ (UIImage*)makeTextTextureImage:(NSString*)text font:(UIFont*)font 
						   color:(UIColor*)color bgcolor:(UIColor*)bgcolor;
@end