//
//  main.m
//  oseroGL2D
//
//  Created by 洲崎 将吾 on 09/12/20.
//  Copyright __MyCompanyName__ 2009. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "Graphics2DEx.h"

//アプリケーションコントローラの宣言
@interface AppController : UIViewController {
    UIView* _contentView;
}
@end

//アプリケーションコントローラの実装
@implementation AppController 

//アプリの初期化
- (id)init {
    if (self=[super init]) {
        self.title=[[[NSBundle mainBundle] infoDictionary]
					objectForKey:@"CFBundleName"];
    }
    return self;
}

//ビューのロード時の処理
- (void)loadView {
	_contentView=[[Graphics2DEx alloc] 
				  initWithFrame:[[UIScreen mainScreen] applicationFrame]];
	
	// add suzaki
	Graphics2DEx* gra = (Graphics2DEx*)_contentView;
	gra.ctrl = self;
	
    self.view=_contentView;
    [_contentView release];
}

//ビューの自動回転のサポート
- (BOOL)shouldAutorotateToInterfaceOrientation:
(UIInterfaceOrientation)interfaceOrientation {
    return NO;
}

//メモリの解放
- (void)dealloc {
    [_contentView release];
    [super dealloc];
}
@end

//アプリケーションデリゲートの宣言
@interface AppDelegate : NSObject <UIApplicationDelegate> {
    UIWindow* _window;
    UINavigationController* _navCtrl;
}
@end

//アプリケーションデリゲートの実装
@implementation AppDelegate
//アプリケーションデリゲートの初期化
- (void)applicationDidFinishLaunching:(UIApplication*)application {
    _window=[[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    AppController* appCtrl=[[AppController alloc] init];
    _navCtrl=[[UINavigationController alloc] 
			  initWithRootViewController:appCtrl];
    _navCtrl.navigationBarHidden=YES;
    [_window addSubview:_navCtrl.view];
    [_window makeKeyAndVisible];
    [appCtrl release];
	
	// ステータスバーを消す
//    [UIApplication sharedApplication].statusBarHidden = NO;
	
	// ステータスバーのStyle設定
	[UIApplication sharedApplication].statusBarStyle = UIStatusBarStyleBlackTranslucent;
	
/*	
	Graphics2DEx* gra = (Graphics2DEx*)appCtrl.view;
	//Graphics2DEx gra;
	
	UIBarButtonItem* button1 = [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemRefresh target:appCtrl action:(SEL)[gra buttonDidPush]] autorelease];
	NSArray* buttons = [NSArray arrayWithObjects:button1, nil];
	
	appCtrl.navigationController.toolbarHidden = NO;
	[appCtrl setToolbarItems:buttons animated:YES];		
 */
}

//アプリケーションデリゲートの後処理
- (void)applicationWillTerminate:(UIApplication*)application {
	// ホームボタンが押されたり、電源を切る場合に呼ばれる
	// 中断されたゲーム状況を保存
	// @todo:既にインスタンスがなかったり。アプリクラッシュしたら当該Function呼ばれないから都度Saveってのも実用的らしい。
	//Graphics2DEx* gra = (Graphics2DEx*)_navCtrl.view;
	//[gra saveGame];
}

//メモリの解放
- (void)dealloc {
    [_window release];
    [_navCtrl release];
    [super dealloc];
}
@end

//メイン
int main(int argc,char *argv[]) {    
    NSAutoreleasePool* pool=[[NSAutoreleasePool alloc] init];
    int retVal=UIApplicationMain(argc,argv,nil,@"AppDelegate");
    [pool release];
    return retVal;
}
